# -*- coding: utf-8 -*-
import os
import time
from common import const, api, config
from util import request_util


if __name__ == '__main__':
    """资源更新客户端
    """

    resp = request_util.post(f'http://127.0.0.1:{const.DAEMON_PORT}/daemon/getState')
    if resp['code'] != 0 or not resp['data']['is_online']:
        raise RuntimeError('未连接到服务器')

    api.get_global_config()
    project = api.get_project()

    print('检查直播素材')
    time.sleep(0.5)
    try:
        url = f'http://{config.ftp_proxy_ip}:17000/proxy/getFileList'
        param = {'uri': f'/shuziren/sucai/{project["name"]}'}
        resp = request_util.post(url, param)
        if resp['code'] == 0:
            for file in resp['data']:
                save_path = os.path.join('C:', file['uri'])
                if not os.path.exists(os.path.dirname(save_path)):
                    os.makedirs(os.path.dirname(save_path))
                if not os.path.exists(save_path):
                    request_util.wget(f'http://{config.ftp_proxy_ip}:8000/shuziren/sucai/{project["name"]}{file["uri"]}', save_path)
                    print(f'下载完成：{os.path.basename(save_path)}')
    except Exception as e:
        print(f'直播素材更新失败：{e}')
        time.sleep(5)
