# -*- coding: utf-8 -*-
from PyQt5.Qt import QWidget, QLineEdit
from daemon.component.dialog.base_dialog import BaseDialog
from daemon.component.widget import Button
from daemon.helper import ui_helper


class InputDialog(BaseDialog):

    def __init__(self, prompt: str, text: str, title: str, parent: QWidget = None):
        """信息提示对话框
        """

        self.text = text
        self.prompt = prompt
        super(InputDialog, self).__init__(title, parent)

    def init_body(self) -> QWidget:
        """初始化对话框主体
        """

        body_widget = QWidget()
        body_widget.setFixedSize(400, 120)

        # 输入框
        self.input_edit = QLineEdit(body_widget)
        if self.text:
            self.input_edit.setText(self.text)
        if self.prompt:
            self.input_edit.setPlaceholderText(self.prompt)
        ui_helper.attr(self.input_edit, font_size=10, x=4, y=10, width=385, height=32, bg_color='#ffffff',
                       border_color='#e3e3e3', radius=2)

        # 提交按钮
        confirm_button = Button('提交', 68, 32, body_widget, font_size=10)
        ui_helper.attr(confirm_button, x=320, y=65, clicked=self.confirm)

        return body_widget

    def exec_(self) -> str:
        """重写exec方法，返回是否点击了确定按钮
        """

        super(BaseDialog, self).exec_()
        return self.input_edit.text() if self.confirm_clicked else ''
