# -*- coding: utf-8 -*-
from abc import ABC
from concurrent.futures import ThreadPoolExecutor
from tornado.concurrent import run_on_executor
from daemon.heartbeat import heartbeat_service
from common.base_handler import BaseHandler


class DaemonHandler(BaseHandler, ABC):
    # 初始化线程池
    executor = ThreadPoolExecutor(20)

    @run_on_executor
    def handle_request(self):
        # 获取状态
        if '/daemon/getState' == self.request.path:
            return {'code': 0, 'msg': '', 'data': {'is_online': heartbeat_service.is_connected}}

        else:
            return {'code': -1, 'msg': 'api not found!', 'data': None}
