# -*- coding: utf-8 -*-
from PyQt5.Qt import QWidget, QLabel, QLineEdit
from daemon.component.base_window_ui import BaseWindowUI
from daemon.component.widget import Button


class SettingWindowUI(BaseWindowUI):

    def init_body(self) -> QWidget:
        """初始化窗口主体
        """

        body_widget = QWidget()
        body_widget.setFixedSize(400, 110)

        # 表单输入框
        self.server_ip_edit = QLineEdit(body_widget)

        # 确定、取消按钮
        self.confirm_button = Button('确定', 70, 32, body_widget, font_size=10)
        self.cancel_button = Button('取消', 70, 32, body_widget, font_size=10)

        # 设置布局
        form_item_list = [(QLabel('服务器IP：', body_widget), self.server_ip_edit)]

        for index, form_item in enumerate(form_item_list):
            form_item[0].setGeometry(0, index * 38, 100, 30)
            form_item[1].setGeometry(108, index * 38, 280, 30)

        self.cancel_button.move(238, 60)
        self.confirm_button.move(318, 60)

        return body_widget
