# -*- coding: utf-8 -*-
import os
import time
import logging
from common import const, filesystem
from util import common_util


def run():
    """清理线程，开播后延迟一轮启动，每轮播完清理一次，即播片段2时，清理片段0
    """

    time.sleep(const.FRAGMENT_SECONDS)

    clean_index = -1

    while True:
        time.sleep(const.FRAGMENT_SECONDS)

        clean_index += 1
        logging.warning(f'开始清理片段{clean_index}')
        clean_t = time.time()

        # 清理wav
        common_util.rmfile(os.path.join(filesystem.runtime_wav_dir, f'{clean_index}.wav'))

        logging.warning(f'片段{clean_index}清理完毕，耗时：{round(time.time() - clean_t, 2)}')
