# -*- coding: utf-8 -*-
import time
from shuziren.data import live_helper
from util import common_util


def get_live_info() -> dict:
    """获取直播状态信息
    """

    manuscript_record_vo_list = []
    rescue_fragment_index_list = []

    for record in live_helper.manuscript_record_list:

        # 添加话术记录
        play_time = common_util.from_time(live_helper.play_start_t + record['play_t'])
        manuscript_record_vo = {'text': record['text'],
                                'play_time': play_time,
                                'goods_index': record['goods_index'],
                                'fragment_index': record['fragment_index'],
                                'is_rescue': record['is_rescue']}
        manuscript_record_vo_list.append(manuscript_record_vo)

        # 添加急救片段序号
        if record['is_rescue'] and record['fragment_index'] not in rescue_fragment_index_list:
            rescue_fragment_index_list.append(record['fragment_index'])

    if live_helper.play_start_t == 0:
        start_time = '00:00:00'
        duration_minutes = 0
    else:
        start_time = common_util.from_time(live_helper.play_start_t)
        duration_minutes = int((time.time() - live_helper.play_start_t) / 60) + 1

    return {'start_time': start_time,
            'duration_minutes': duration_minutes,
            'manuscript_record_list': manuscript_record_vo_list,
            'fragment_count': live_helper.play_index + 1,
            'rescue_fragment_count': len(rescue_fragment_index_list)}
