# -*- coding: utf-8 -*-
import re
import logging
from abc import ABC
from concurrent.futures import ThreadPoolExecutor
from tornado.concurrent import run_on_executor
from shuziren.controller.dt import live_dt
from shuziren.data import live_helper, interact_helper
from common.base_handler import BaseHandler

douyin_name = None


def remove_bracketed_text(text):
    # 匹配方括号及其内部内容（非贪婪模式）
    pattern = r'\[.*?\]'
    text = re.sub(pattern, '', text)

    # 只保留中文汉字、逗号、句号、感叹号、问号、数字、字母
    pattern = r'[^\u4e00-\u9fa5a-zA-Z0-9,。!?！？]'
    text = re.sub(pattern, '', text)

    return text


class LiveHandler(BaseHandler, ABC):
    # 初始化线程池
    executor = ThreadPoolExecutor(100)

    @run_on_executor
    def handle_request(self):
        global douyin_name
        # 追加交互文本
        if '/live/addInteractText' == self.request.path:
            interact = interact_helper.get_interact_text(self.arg('message'))
            if interact is not None and len(interact['content']) > 0:
                if interact['user'] != douyin_name:
                    live_helper.interact_text_list.append(remove_bracketed_text(interact['content']))
                    # 添加到队列，等待chrome进程读取
                    live_helper.chrome_interact_list.append(interact)
            return {'code': 0, 'msg': '', 'data': None}

        elif '/live/getInteractList' == self.request.path:
            tmp_list = []
            while len(live_helper.chrome_interact_list) > 0:
                tmp_list.append(live_helper.chrome_interact_list.pop(0))
            return {'code': 0, 'msg': '', 'data': tmp_list}

        elif '/live/setDouyinName' == self.request.path:
            douyin_name = self.arg('douyin_name')
            return {'code': 0, 'msg': '', 'data': None}

        # 获取直播状态信息
        elif '/live/getLiveInfo' == self.request.path:
            logging.warning('开始获取直播状态信息')
            live_info = live_dt.get_live_info()
            logging.warning(f'状态信息：{live_info}')
            return {'code': 0, 'msg': '', 'data': live_info}

        else:
            return {'code': -1, 'msg': 'api not found!', 'data': None}
