# -*- coding: utf-8 -*-
import datetime
from util import manuscript_util

# 报时记录列表
clock_history_list = []


def get_tts_clock_text() -> str:
    """获取报时文本，无需报时返回空字符串
    """

    global clock_history_list

    now = datetime.datetime.now()
    period = '上午' if now.strftime('%p') == 'AM' else '下午'
    hour = now.strftime('%I').lstrip('0')
    minute = now.minute

    clock_text = ''
    if (period, hour, 1) not in clock_history_list and 0 <= minute < 5:
        clock_history_list.append((period, hour, 1))
        clock_text = f'{{现在|这会儿}}才{{刚过|刚到}}{period}{hour}点。'

    elif (period, hour, 2) not in clock_history_list and 15 <= minute < 20:
        clock_history_list.append((period, hour, 2))
        clock_text = f'{{马上|很快|眼看}}就要到{hour}点20了。'

    elif (period, hour, 3) not in clock_history_list and 25 <= minute < 30:
        clock_history_list.append((period, hour, 3))
        clock_text = f'{{马上|很快|眼看}}就要到{hour}点半了。'

    elif (period, hour, 4) not in clock_history_list and 50 <= minute < 55:
        clock_history_list.append((period, hour, 4))
        try:
            clock_text = f'{{现在|马上}}已经快到{int(hour) + 1}点了。'
        except Exception:
            pass

    if clock_text != '':
        clock_text = manuscript_util.gen_manuscript(clock_text)
        clock_text += manuscript_util.gen_manuscript('直播间的{家人|宝子}们{帮忙|帮主播}点点关注。')

    return clock_text
