# -*- coding: utf-8 -*-
import os
import time
import logging
from shuziren.consumer import play_thread, clean_thread
from shuziren.producer import tts_thread
from shuziren.data import live_helper, interact_helper
from common import api, filesystem, const
from util import common_util, volume_util


def start_live():
    """启动直播任务
    """

    api.get_global_config()
    project = api.get_project()
    logging.info(f'直播产品信息：{project}')
    if project is None:
        raise RuntimeError('请先选择直播产品')

    if project['manuscript']['text'] == '':
        raise RuntimeError('请先配置产品文案')

    if project['timbre_name'] == '':
        raise RuntimeError('请先配置主播音色')

    api.add_alert(const.LEVEL_NORMAL, '已开播')
    # 启动直播任务
    __exec_live()


def __exec_live():
    """处理直播任务状态
    """

    ret = 0
    while True:
        # 未开播 -> 准备中
        if live_helper.state == live_helper.STATE_NONE:
            logging.warning('准备直播任务')
            __prepare_live()

        # 准备中 -> 等待准备完成
        elif live_helper.state == live_helper.STATE_PREPARE:
            __wait_prepare()

        # 准备完成 -> 已开播
        elif live_helper.state == live_helper.STATE_READY:
            logging.warning('直播任务准备完成')
            __run_live()

        # 已开播 -> 等待直播结束
        elif live_helper.state == live_helper.STATE_RUN:
            pass

        time.sleep(1)
        # 60s打印一次日志并检查修改MediaSDK_Server.exe进程的音量、检查一下是否需要自动回复
        ret += 1
        if live_helper.play_start_t != 0 and ret % 60 == 0:
            duration_minutes = int((time.time() - live_helper.play_start_t) / 60) + 1
            logging.warning(f'已开播{duration_minutes}分钟，当前播放片段{live_helper.play_index}')
            # 修改直播伴侣监听音量为0%
            volume_util.set_process_volume('MediaSDK_Server.exe', 0.0)

            chime_text = interact_helper.get_chime_text()
            if chime_text != '':
                live_helper.chrome_interact_list.append({'user': '所有人', 'content': chime_text})
                live_helper.interact_text_list.append(chime_text)


def __prepare_live():
    """准备开播，预生成音频和片段
    """

    # 直播状态改为准备中
    live_helper.set_live_state(live_helper.STATE_PREPARE)

    # 开启TTS线程生成音频
    common_util.start_thread(tts_thread.run)


def __wait_prepare():
    """等待准备完成，即等待首个片段生成完毕
    """

    if len(live_helper.wav_list) > 0:
        live_helper.set_live_state(live_helper.STATE_READY)


def __run_live():
    """开播
    """

    # 直播任务状态改为已开播
    live_helper.set_live_state(live_helper.STATE_RUN)

    # 开启播放线程
    common_util.start_thread(play_thread.run)

    # 开启文件清理线程
    common_util.start_thread(clean_thread.run)
