# -*- coding: utf-8 -*-
import sys
import logging
import tornado.web
import tornado.ioloop
from PyQt5.Qt import QApplication, QFont
from daemon.ui.tray_icon import TrayIcon
from daemon.heartbeat import heartbeat_service
from daemon.controller.daemon_handler import DaemonHandler
from daemon.helper import ui_helper
from common import const, filesystem
from util import log_util, common_util


def __config_tornado():
    """配置tornado
    """

    tornado.web.Application([
        # 状态管理
        ('/daemon/.*', DaemonHandler)

    ], static_hash_cache=False).listen(const.DAEMON_PORT, xheaders=True, max_buffer_size=1024 * 1024 * 1024 * 10)


if __name__ == '__main__':
    """数字人后台进程
    """

    log_util.init_logging()
    logging.info('数字人后台进程已启动')

    # 创建qApp程序，并设置系统语言为中文
    app = QApplication(sys.argv)
    if common_util.is_win():
        app.setFont(QFont('Tahoma, 黑体'))
    ui_helper.install_translator(app, filesystem.qt_zh_cn_path)

    # 托盘图标
    tray_icon = TrayIcon()
    tray_icon.show()

    # 启动心跳客户端
    common_util.start_thread(heartbeat_service.start)

    # 子线程启动tornado
    __config_tornado()
    common_util.start_thread(tornado.ioloop.IOLoop.current().start)

    # 禁止默认的close方法，只能使用sys.exit(0)方法退出程序，避免调用关闭方法导致程序退出
    QApplication.setQuitOnLastWindowClosed(False)
    # qApp接管程序生命周期
    sys.exit(app.exec_())
