# -*- coding: utf-8 -*-
import time
import logging
from chrome.data import chrome_helper
from common import api, const
from util import request_util


def run_trade_thread():
    """收入数据抓取线程，同时判断巨量百应登陆状态
    """

    ret = 0
    while True:
        time.sleep(10)
        # 2分钟一次
        if ret % 12 == 0:
            ret += 1
            logging.warning('抓取收入数据')
            # 抓取收入数据，判断巨量百应登陆状态
            trade_info = chrome_helper.get_trade_info()
            logging.warning(f'抓取收入数据完成：{trade_info}')
            api.update_trade_info(trade_info)
            # 抖音名称推送给直播线程
            request_util.post(f'http://127.0.0.1:{const.SHUZIREN_PORT}/live/setDouyinName', {'douyin_name': trade_info['douyin_name']})

        try:
            resp = request_util.post(f'http://127.0.0.1:{const.SHUZIREN_PORT}/live/getInteractList')
            if resp['code'] == 0:
                message_list = resp['data']
                for message in message_list:
                    logging.warning('发送弹幕')
                    chrome_helper.send_message(message)
                    logging.warning(f'发送弹幕完成')
        except Exception:
            logging.warning(f'发送弹幕失败')
