# -*- coding: utf-8 -*-
import os
import sys

# 程序文件同级目录
exe_dir = os.path.split(os.path.abspath(sys.argv[0]))[0]

# 用户家目录
home_dir = os.path.expanduser('~')

# 用户桌面目录
desktop_dir = os.path.join(home_dir, 'Desktop')

# 家目录中的.hxops目录，需要判断不存在时创建
hxops_dir = os.path.join(home_dir, '.hxops')

# 日志目录
log_dir = os.path.join(hxops_dir, 'log')

# static文件夹
static_dir = os.path.join(exe_dir, 'static')

# 资源目录
assets_dir = os.path.join(exe_dir, 'assets')
ic_logo = os.path.join(assets_dir, 'ic_logo.png')
ic_logo_offline = os.path.join(assets_dir, 'ic_logo_offline.png')
ic_title_logo = os.path.join(assets_dir, 'ic_title_logo.png')
ic_minimize = os.path.join(assets_dir, 'ic_minimize.png')
ic_minimize_active = os.path.join(assets_dir, 'ic_minimize_active')
ic_maximize = os.path.join(assets_dir, 'ic_maximize.png')
ic_maximize_active = os.path.join(assets_dir, 'ic_maximize_active')
ic_close = os.path.join(assets_dir, 'ic_close.png')
ic_close_active = os.path.join(assets_dir, 'ic_close_active.png')
ic_loading = os.path.join(assets_dir, 'ic_loading.gif')
qt_zh_cn_path = os.path.join(assets_dir, 'qt_zh_CN.qm')

# 配置文件
server_ip_path = os.path.join(exe_dir, 'server_ip.txt')
mac_path = os.path.join(exe_dir, 'mac.txt')

# wav文件夹
wav_dir = os.path.join(static_dir, 'wav')
runtime_wav_dir = os.path.join(wav_dir, 'runtime')
blank_wav_path = os.path.join(wav_dir, 'blank.wav')

# ffmpeg文件
ffmpeg_path = os.path.join(exe_dir, 'ffmpeg.exe')

# TTS文件
tts_model_dir = os.path.join(exe_dir, 'ttsruntime', 'model')
tts_output_dir = os.path.join(exe_dir, 'ttsruntime', 'output')

# VNC文件
vnc_path = os.path.join(exe_dir, 'start_vnc.bat')

# 关播文件
quit_shuziren_path = os.path.join(exe_dir, 'quit_shuziren.bat')

# chrome_driver文件
# chrome_driver_path = os.path.join(exe_dir, 'chrome', 'chromedriver.exe')
chrome_driver_path = 'C:\\shuziren\\chrome\\chromedriver.exe'

# 日志文件
log_path = os.path.join(log_dir, f'{sys.argv[0]}.log')

# 素材文件夹
assets_dir = 'C:\\sucai'

# 模型文件夹
model_dir = 'C:\\model'

# 文件夹不存在时创建
if not os.path.exists(hxops_dir):
    os.mkdir(hxops_dir)

if not os.path.exists(log_dir):
    os.mkdir(log_dir)

if not os.path.exists(assets_dir):
    os.mkdir(assets_dir)

if not os.path.exists(model_dir):
    os.mkdir(model_dir)
