# -*- coding: utf-8 -*-
import time
from PyQt5.Qt import QWidget, QSize, QLabel, QMovie, QTimer, QKeyEvent
from daemon.component.dialog.base_dialog import BaseDialog
from daemon.helper import ui_helper
from common import filesystem


class LoadingDialog(BaseDialog):

    def __init__(self, parent: QWidget = None):
        """加载中对话框
        """

        self.loading_time = 0
        self.need_show = False
        self.text = '加载中...'

        super(LoadingDialog, self).__init__(self.text, parent)
        self.title_bar.close_button.setVisible(False)
        # 每0.2秒检查一次是否需要显示，最长显示15秒超时隐藏
        self.timer = QTimer(self)
        self.timer.timeout.connect(self.__handle_timer_timeout)
        self.timer.start(200)

    def init_body(self) -> QWidget:
        """初始化对话框主体
        """

        body_widget = QWidget()
        body_widget.setFixedSize(300, 90)

        # 加载中动画
        self.loading_label = QLabel(body_widget)
        ui_helper.attr(self.loading_label, x=-50, y=-120, width=400, height=300)
        self.loading_label.setMovie(QMovie(filesystem.ic_loading))
        self.loading_label.movie().setScaledSize(QSize(400, 300))
        self.loading_label.movie().start()

        return body_widget

    def keyPressEvent(self, event: QKeyEvent):
        """回车键和ESC不再关闭对话框
        """

        pass

    def loading(self, text: str):
        """开始加载，记录开始时间，15秒超时隐藏，可以在子线程中调用
        """

        self.need_show = True
        self.text = text
        self.loading_time = time.time()

    def stop(self):
        """停止加载
        """

        self.loading_time = 0
        self.hide()

    def __handle_timer_timeout(self):
        """每0.2秒检查一次是否需要显示，15秒超时隐藏，可以在子线程中调用
        """

        if not self.isVisible() and self.need_show:
            self.need_show = False
            ui_helper.show_window(self)
            self.setWindowTitle(self.text)
            self.title_bar.title_label.setText(self.text)

        elif self.isVisible() and time.time() - self.loading_time > 15:
            self.hide()
