# -*- coding: utf-8 -*-
import time
import psutil
import logging
from common import const, config, filesystem
from util import common_util, request_util, cmd_util

# 是否连接服务器
is_connected = False

# 回执列表，每次心跳时pop一条
__task_callback_list = []

# 任务名称
__TASK_CONNECT_VNC = '打开远程桌面'
__TASK_GET_LIVE_INFO = '获取直播状态信息'
__TASK_QUIT_LIVE = '关播'
__TASK_REBOOT = '重启'


def start():
    """启动心跳客户端，与服务器建立连接
    """

    global is_connected
    mac = None
    while True:
        time.sleep(2)
        server_ip = config.get_server_ip()

        # 判断服务器IP是否为空
        if server_ip == '':
            continue

        # 判断MAC地址是否获取成功
        if mac is None or mac == '00:00:00:00:00:00':
            mac = common_util.get_mac(server_ip)
        if mac is None or mac == '00:00:00:00:00:00':
            continue

        # 请求地址
        url = f'http://{server_ip}/client/heartbeat'

        # 主机状态字典
        shuziren_start_t = common_util.get_process_start_timestamp('shuziren_client.exe')
        state_dict = {'startup_hours': common_util.calc_duration_hours(psutil.boot_time()),
                      'shuziren_run_hours': common_util.calc_duration_hours(shuziren_start_t)}

        task_callback = None
        if len(__task_callback_list) > 0:
            task_callback = __task_callback_list.pop(0)

        # 请求参数
        params = {'host_name': const.HOST_NAME,
                  'mac': mac,
                  'client_version': const.CLIENT_VERSION,
                  'state_dict': state_dict,
                  'task_callback': task_callback}

        # 发送心跳包
        resp = request_util.post(url, params)

        # 请求成功，状态改为在线
        if resp['code'] == 0:
            is_connected = True

            # 子线程处理任务
            if resp['data']['task'] is not None:
                common_util.start_thread(__exec_task, (resp['data']['task'],))

        # 请求失败，状态改为离线
        else:
            is_connected = False


def __exec_task(task: dict):
    """处理任务
    task: {id: int, name: str, params: dict?, callback: callable}
    """

    global __task_callback_list
    callback_data = None

    logging.info(f'开始执行任务：{task["name"]}')

    # 打开远程桌面
    if task['name'] == __TASK_CONNECT_VNC:
        vnc_server_ip = task['params']['vnc_server_ip']
        vnc_server_port = task['params']['vnc_server_port']
        cmd_util.cmd_async('start "" "{}" {}:{}'.format(filesystem.vnc_path, vnc_server_ip, vnc_server_port))

    # 获取直播状态信息
    elif task['name'] == __TASK_GET_LIVE_INFO:
        resp = request_util.post(f'http://127.0.0.1:{const.SHUZIREN_PORT}/live/getLiveInfo', timeout=15)
        if resp['code'] == 0:
            callback_data = resp['data']

    # 关播
    # elif task['name'] == __TASK_QUIT_LIVE:
    #     # 关闭数字人进程
    #     cmd_util.cmd_async(f'start "" "{filesystem.quit_shuziren_path}"')
    #     time.sleep(2)
    #
    #     # 关播
    #     is_success = False
    #     resp = request_util.post(f'http://127.0.0.1:{const.DOUYIN_PORT}/douyin/quitLive', timeout=45)
    #     if resp['code'] == 0:
    #         is_success = resp['data']['is_success']
    #     callback_data = is_success

    # 重启
    elif task['name'] == __TASK_REBOOT:
        cmd_util.cmd('shutdown /f /r /t 0')

    logging.info(f'任务执行完毕：{task["name"]}')
    __task_callback_list.append({'task_id': task['id'], 'data': callback_data})
