# -*- coding: utf-8 -*-
from PyQt5.Qt import QSystemTrayIcon, QIcon, QPixmap, QMenu, QTimer
from daemon.ui.setting_window import SettingWindow
from daemon.heartbeat import heartbeat_service
from common import filesystem


class TrayIcon(QSystemTrayIcon):

    def __init__(self):
        """托盘图标
        """

        super(TrayIcon, self).__init__()
        self.setIcon(QIcon(QPixmap(filesystem.ic_logo_offline)))
        self.setToolTip('云运维')

        # 点击事件
        self.activated.connect(self.__handle_tray_icon_activate)

        # 右键菜单
        context_menu = QMenu()
        context_menu.addAction('设置', SettingWindow.show_)
        self.setContextMenu(context_menu)

        # 定时检查客户端连接状态，更新图标状态
        self.timer = QTimer()
        self.timer.timeout.connect(self.__check_ws_connected)
        self.timer.start(2000)

    @staticmethod
    def __handle_tray_icon_activate(reason: int):
        """鼠标左键单击或双击时，激活主窗口
        """

        if reason == 2 or reason == 3:
            SettingWindow.show_()

    def __check_ws_connected(self):
        """检查客户端连接状态，更新图标状态
        """

        if heartbeat_service.is_connected:
            self.setIcon(QIcon(QPixmap(filesystem.ic_logo)))
        else:
            self.setIcon(QIcon(QPixmap(filesystem.ic_logo_offline)))
