# -*- coding: utf-8 -*-
import time
import logging
from chrome import chrome_service
from common import const
from util import log_util, common_util, request_util


if __name__ == '__main__':
    """谷歌客户端
    """

    log_util.init_logging()
    logging.warning('谷歌客户端已启动')

    resp = request_util.post(f'http://127.0.0.1:{const.DAEMON_PORT}/daemon/getState')
    if resp['code'] != 0 or not resp['data']['is_online']:
        raise RuntimeError('未连接到服务器')

    # 启动收入数据抓取线程
    common_util.start_thread(chrome_service.run_trade_thread)

    while True:
        time.sleep(1)
