# -*- coding: utf-8 -*-
from common import config, const
from util import request_util, common_util

# 缓存产品信息，减少请求频率
__cached_project = None
__cached_project_timestamp = 0
__CACHED_PROJECT_SECONDS = 30.0


def check_update() -> dict or None:
    """
    """

    url = 'http://' + config.get_server_ip() + '/client/checkUpdate'
    params = {'version': const.CLIENT_VERSION}
    resp = request_util.post(url, params)
    if resp['code'] == 0 and resp['data'].get('need_update') is True:
        return resp['data']
    return None


def get_global_config():
    """
    """

    from common import config
    url = 'http://' + config.get_server_ip() + '/client/getGlobalConfig'
    resp = request_util.post(url)
    if resp['code'] == 0:
        config.alert_keyword_list = resp['data'].get('alert_keyword_list', [])
        config.alert_exclude_keyword_list = resp['data'].get('alert_exclude_keyword_list', [])
        config.mixin_offset_range = resp['data'].get('mixin_offset_range', [0, 0])
        config.mixin_offset_frequency = resp['data'].get('mixin_offset_frequency', 0)
        config.openai_base_url = resp['data'].get('openai_base_url', '')
        config.openai_api_key = resp['data'].get('openai_api_key', '')
        config.openai_model = resp['data'].get('openai_model', '')
        config.openai_input = resp['data'].get('openai_input', '')
        config.openai_chime_input = resp['data'].get('openai_chime_input', '')
        config.ftp_proxy_ip = resp['data'].get('ftp_proxy_ip', '')


def get_project() -> dict or None:
    """
    """

    global __cached_project, __cached_project_timestamp
    from common import const
    if common_util.timestamp() - __cached_project_timestamp > __CACHED_PROJECT_SECONDS:
        url = 'http://' + config.get_server_ip() + '/client/getProjectInfo'
        params = {'host_name': const.HOST_NAME}
        resp = request_util.post(url, params)
        if resp['code'] == 0:
            __cached_project = resp['data']

            # 更新缓存时间
            __cached_project_timestamp = common_util.timestamp()

    return __cached_project


def add_alert(level: str, content: str, image_b64: str = None):
    """
    """

    from common import const
    url = 'http://' + config.get_server_ip() + '/client/alert'
    params = {'host_name': const.HOST_NAME, 'level': level, 'content': content, 'image_b64': image_b64}
    request_util.post(url, params)


def update_grab_image(image_b64: str):
    """
    """

    from common import const
    url = 'http://' + config.get_server_ip() + '/client/updateGrabImage'
    params = {'host_name': const.HOST_NAME, 'image_b64': image_b64}
    request_util.post(url, params)


def update_comment_message_list(comment_message_list: list):
    """
    """

    from common import const
    url = 'http://' + config.get_server_ip() + '/client/updateCommentMessageList'
    params = {'host_name': const.HOST_NAME, 'comment_message_list': comment_message_list}
    request_util.post(url, params)


def update_trade_info(trade_info: dict):
    """
    """

    from common import const
    url = 'http://' + config.get_server_ip() + '/client/updateTradeInfo'
    params = {'host_name': const.HOST_NAME, 'trade_info': trade_info}
    request_util.post(url, params)


def check_alert() -> str:
    """
    """

    url = 'http://' + config.get_server_ip() + '/client/checkAlert'
    resp = request_util.post(url)
    if resp['code'] == 0:
        return resp['data']['host_names']
    return ''
