# -*- coding: utf-8 -*-
from util import common_util

# 叠加图片偏移量范围、频率
mixin_offset_range = [0, 0]
mixin_offset_frequency = 0

# 违规警告关键字列表
alert_keyword_list = []
alert_exclude_keyword_list = []

# 大模型参数
openai_base_url = ''
openai_api_key = ''
openai_model = ''
openai_input = ''
openai_chime_input = ''

# FTP代理服务器地址
ftp_proxy_ip = '127.0.0.1'


def get_server_ip() -> str:
    """获取服务器IP，获取失败时返回空字符串
    """

    from common import filesystem
    return common_util.read_file(filesystem.server_ip_path).strip()


def set_server_ip(server_ip: str):
    """设置服务器IP
    """

    from common import filesystem
    common_util.write_file(filesystem.server_ip_path, server_ip)
