# -*- coding: utf-8 -*-
import os
import sys
import socket

# 版本号
with open(f'{os.path.join(os.path.split(os.path.abspath(sys.argv[0]))[0], "version.txt")}', 'r') as f:
    CLIENT_VERSION = f.read().strip()

# 主机信息
HOST_NAME = socket.gethostname()

# DEBUG模式
IS_DEBUG = len(sys.argv) > 1 and sys.argv[1] == '--debug'

# 端口号
SHUZIREN_PORT = 9010
DAEMON_PORT = 9011

TTS1_PORT = 9015
TTS2_PORT = 9016

CHROME_PORT = 9017

# 数字人每个wav及mp4片段的时长
FRAGMENT_SECONDS = 30.0

# wav参数
WAV_CHUNK_SIZE = 1024
WAV_MAX_CHUNK_SIZE = 1024 * 1000 * 1000 * 1000 * 1000 * 1000  # 1024PB
WAV_RATE = 24000
WAV_CHANNELS = 1

# mp4参数
MP4_FRAME_RATE = 25.0
MP4_FRAME_SECONDS = (1000.0 / MP4_FRAME_RATE) / 1000.0
MP4_FRAMES = int(MP4_FRAME_RATE * FRAGMENT_SECONDS)

# 每轮TTS生成条数
TTS_ROUND_COUNT = 5

# 最大预生成音频条数，超出后暂停预生成
WAV_PREPARE_MAX_COUNT = 30

# 抖音弹幕类型
# 弹幕评论
TYPE_COMMENT = 'comment'
# 进房
TYPE_ENTER = 'enter'
# 关注
TYPE_FOLLOW = 'follow'
# 点赞
TYPE_LIKE = 'like'
# 礼物
TYPE_GIFT = 'gift'
# 未处理的消息类型
TYPE_UNKNOWN = 'unknown'

# 告警等级
LEVEL_WARNING = '严重'
LEVEL_NORMAL = '一般'
