# -*- coding: utf-8 -*-
from PyQt5.Qt import Qt, QLabel, QWidget
from daemon.component.dialog.base_dialog import BaseDialog
from daemon.component.widget import Button
from daemon.helper import ui_helper


class MessageDialog(BaseDialog):

    def __init__(self, text: str, title: str, parent: QWidget = None):
        """信息提示对话框
        """

        self.text = text
        super(MessageDialog, self).__init__(title, parent)

    def init_body(self) -> QWidget:
        """初始化对话框主体
        """

        body_widget = QWidget()
        body_widget.setFixedSize(440, 130)

        text_label = QLabel(body_widget)
        ui_helper.attr(text_label, x=4, width=425, height=54, text=self.text, text_line=3, align=Qt.AlignTop)
        confirm_button = Button('好的', 68, 32, body_widget, font_size=10)
        ui_helper.attr(confirm_button, x=366, y=75, clicked=self.confirm)

        return body_widget
