# -*- coding: utf-8 -*-
from daemon.ui._setting_window_ui import SettingWindowUI
from daemon.helper import ui_helper
from common import config


class SettingWindow(SettingWindowUI):

    instance = None

    @staticmethod
    def show_():
        """显示窗口
        """

        if SettingWindow.instance is None:
            SettingWindow.instance = SettingWindow()
        ui_helper.show_window(SettingWindow.instance)

    def __init__(self):
        """设置对话框
        """

        super(SettingWindow, self).__init__('设置')
        # 确定、取消按钮
        self.confirm_button.clicked.connect(self.__handle_confirm_clicked)
        self.cancel_button.clicked.connect(self.close)
        # 记录旧的服务器IP
        self.old_server_ip = None

    def show(self):
        """重写show方法刷新数据
        """

        super(SettingWindow, self).show()

        # 服务器IP输入框，不显示默认端口号17000
        self.old_server_ip = config.get_server_ip().replace(':17000', '')
        self.server_ip_edit.setText(self.old_server_ip)

    def __handle_confirm_clicked(self):
        """确定按钮点击事件
        """

        # 获取设置的服务器IP，远程控制状态和开机自启状态
        server_ip = self.server_ip_edit.text().strip()

        # 不填端口号时设置默认端口号17000
        if server_ip != '' and ':' not in server_ip:
            server_ip += ':17000'

        # Windows 修改服务器IP
        config.set_server_ip(server_ip)
        self.close()
