# -*- coding: utf-8 -*-
import os
import time
import zipfile
import shutil
from common import const, api, filesystem
from util import request_util


if __name__ == '__main__':
    """资源更新客户端
    """

    resp = request_util.post(f'http://127.0.0.1:{const.DAEMON_PORT}/daemon/getState')
    if resp['code'] != 0 or not resp['data']['is_online']:
        raise RuntimeError('未连接到服务器')

    api.get_global_config()
    project = api.get_project()

    print('检查C:\\model\\主播音色资源')
    time.sleep(0.5)
    try:
        if project['timbre_model'] is not None:
            timbre_path = os.path.join(filesystem.model_dir, project['timbre_model']['name'])
            if not os.path.exists(timbre_path):
                request_util.wget(project['timbre_model']['url'], timbre_path)

                try:
                    shutil.rmtree(filesystem.tts_model_dir)
                except Exception:
                    pass
                try:
                    os.mkdir(filesystem.tts_model_dir)
                except Exception:
                    pass

                with zipfile.ZipFile(timbre_path, 'r') as f:
                    f.extractall(filesystem.tts_model_dir)
    except Exception as e:
        print(f'主播音色资源更新失败：{e}')
        time.sleep(5)
