# -*- coding: utf-8 -*-
import time
from util import wav_util

STATE_NONE = 0
STATE_PREPARE = 1
STATE_READY = 2
STATE_RUN = 3
STATE_ERROR = 4

# 直播状态
state = STATE_NONE

# wav队列 [{path: str, duration: float, text: str, goods_index: int or None, fragment_index: int}]
wav_list = []
assistant_wav_list = []

# wav队列操作锁
wav_list_lock = False

# 话术记录列表，合成片段前记录 [{text: str, play_t: float, duration: float, goods_index: int, is_rescue: bool}]
manuscript_record_list = []

# 播放当前片段的开始时刻
play_fragment_t = 0

# 播放序号，每播放1个片段+1
play_index = -1

# 新片段保存操作锁
fragment_save_lock = False

# GPU操作锁
gpu_lock = False

# CHROME操作锁
__chrome_lock = False

# 交互文本列表
interact_text_list = []

# 直播开始时间（播放线程启动时间）
play_start_t = 0

# chrome弹幕交互列表
chrome_interact_list = []


def set_live_state(new_state: int):
    """更新直播状态
    """

    global state
    if new_state not in [STATE_PREPARE, STATE_READY, STATE_RUN, STATE_ERROR] or state > new_state:
        raise RuntimeError(f'直播任务状态不正确，设置状态失败，当前状态：{state}，新状态：{new_state}')

    state = new_state


def wav_obj(wav_path: str, text: str, goods_index: int or None):
    """构造wav对象
    """

    duration = wav_util.get_wav_duration(wav_path)
    wav = {'path': wav_path, 'duration': duration, 'text': text, 'goods_index': goods_index}
    return wav


def insert_wav(wav: dict, is_assistant: bool = False):
    """插入音频
    """

    global wav_list, wav_list_lock
    # 等待锁释放后加锁
    while wav_list_lock:
        time.sleep(0.02)
    wav_list_lock = True

    if not is_assistant:
        wav_list.append(wav)
    else:
        assistant_wav_list.append(wav)

    # 释放锁
    wav_list_lock = False


def pop_wav() -> dict or None:
    """取出音频，没有音频可以取出时，返回None
    """

    global wav_list, assistant_wav_list, wav_list_lock
    # 等待锁释放后加锁
    while wav_list_lock:
        time.sleep(0.02)
    wav_list_lock = True

    # 取出音频
    if len(assistant_wav_list) > 0:
        wav = assistant_wav_list.pop(0)
    elif len(wav_list) > 0:
        wav = wav_list.pop(0)
    else:
        wav = None

    # 释放锁
    wav_list_lock = False
    return wav


def append_manuscript_record(text: str, duration: float, goods_index: int or None, fragment_index: int, is_rescue: bool = False):
    """追加话术记录
    """

    global manuscript_record_list

    # 计算当前话术的开始播放时间，第一条话术从0.0开始
    if len(manuscript_record_list) == 0:
        play_t = 0.0
    else:
        play_t = manuscript_record_list[-1]['play_t'] + manuscript_record_list[-1]['duration']

    manuscript_record = {'text': text, 'play_t': play_t, 'duration': duration, 'goods_index': goods_index, 'fragment_index': fragment_index, 'is_rescue': is_rescue}
    manuscript_record_list.append(manuscript_record)
