# -*- coding: utf-8 -*-
import cgitb
import logging
import logging.handlers


class LevelFileHandler(logging.handlers.TimedRotatingFileHandler):

    def __init__(self, filename: str, level: int):
        """每天切分日志的Handler
        """

        super().__init__(filename, when='midnight', encoding='UTF-8')
        self.setLevel(level)

    def emit(self, record):
        """只输出指定level的日志
        """

        super().emit(record)
        # if record.levelno == self.level:
        #     super().emit(record)


def init_logging():
    """初始化 全局logging对象 和 全局崩溃捕获模块
    """

    from common import filesystem
    logging.basicConfig(level=logging.INFO,
                        format='%(asctime)s %(filename)s [line:%(lineno)d] %(message)s',
                        datefmt='%m/%d %H:%M:%S',
                        handlers=[LevelFileHandler(filesystem.log_path, logging.INFO), logging.StreamHandler()])
    # 禁用tornado日志
    logging.getLogger('tornado.access').propagate = False
    logging.getLogger('tornado.application').propagate = False
    logging.getLogger('tornado.general').propagate = False
    # 禁用getmac日志
    logging.getLogger('getmac').propagate = False
    # 设置requests日志输出等级，warning等级以下的日志不输出
    logging.getLogger('requests').setLevel(logging.WARNING)
    # 崩溃捕获
    cgitb.enable(format='text', logdir=filesystem.log_dir)
