# -*- coding: utf-8 -*-
from pycaw.pycaw import AudioUtilities, ISimpleAudioVolume


def set_process_volume(process_name: str, volume_level: float):
    """修改指定进程的音量 0.1~1.0
    """

    try:
        sessions = AudioUtilities.GetAllSessions()
        for session in sessions:
            if session.Process and session.Process.name() == process_name:
                volume = session._ctl.QueryInterface(ISimpleAudioVolume)
                volume.SetMasterVolume(volume_level, None)
    except Exception:
        pass
