# -*- coding: utf-8 -*-
import os
import time
import wave
import pyaudio
import logging
from shuziren.data import live_helper
from common import const, filesystem, api, config


def run():
    """开播线程
    """

    # 初始化wav播放器
    wav_player, wav_stream = __init_wav_player()

    # 记录开播时间
    live_helper.play_start_t = time.time()

    while True:
        live_helper.play_index += 1
        live_helper.play_fragment_t = time.time()

        wav = live_helper.pop_wav()
        # 播放片段
        if wav is not None:
            logging.warning(f'播放片段{live_helper.play_index}')
            try:
                with wave.open(wav['path'], 'rb') as wf:
                    wav_stream.write(wf.readframes(const.WAV_MAX_CHUNK_SIZE))

            except Exception as e:
                logging.warning(f'片段{live_helper.play_index}播放失败，等待{const.FRAGMENT_SECONDS}秒 {e}')
                api.add_alert(const.LEVEL_WARNING, '数字人中断-播放失败')
                # 重新初始化wav播放器
                wav_player, wav_stream = __init_wav_player()
                time.sleep(const.FRAGMENT_SECONDS)

        # 片段不存在，等待一轮
        else:
            logging.warning(f'片段{live_helper.play_index}不存在，等待{const.FRAGMENT_SECONDS}秒')
            api.add_alert(const.LEVEL_WARNING, '数字人中断-片段不存在')
            time.sleep(const.FRAGMENT_SECONDS)

        # 播放完毕
        play_fragment_end_t = time.time()

        logging.warning(f'片段{live_helper.play_index}播放完毕，'
                        f'耗时：{round(play_fragment_end_t - live_helper.play_fragment_t, 2)}，'
                        f'累计耗时：{round(play_fragment_end_t - live_helper.play_start_t, 2)}')


def __init_wav_player() -> tuple:
    """初始化wav音频播放器
    """

    wav_player = pyaudio.PyAudio()
    wav_stream = wav_player.open(format=pyaudio.paInt16, channels=const.WAV_CHANNELS, rate=const.WAV_RATE,
                                 frames_per_buffer=0, output=True)

    # 播放空白音频，激活播放器，避免开播后激活造成耗时
    with open(filesystem.blank_wav_path, 'rb') as f:
        wav_stream.write(f.read())

    time.sleep(1)
    return wav_player, wav_stream
