# -*- coding: utf-8 -*-
import random
import logging
from openai import OpenAI
from common import const, api, config
from util import common_util, manuscript_util

# 自动回复时间戳
chime_timestamp = 0


def get_chime_text() -> str:
    """获取定时自动回复发送的文本，无需回复时返回空字符串
    """

    global chime_timestamp
    project = api.get_project()
    if project is None:
        return ''

    # 判断是否启用自动回复 且 满足时间间隔
    now_timestamp = common_util.timestamp()
    if project['chime']['enable'] and now_timestamp - chime_timestamp > project['chime']['interval']:

        # 更新自动回复时间
        chime_timestamp = now_timestamp

        openai_chime_input_list = []
        for _chime_input in config.openai_chime_input.split('\n'):
            if _chime_input.strip() != '':
                openai_chime_input_list.append(_chime_input.strip())
        # 获取自动回复文本
        try:
            client = OpenAI(
                api_key=config.openai_api_key,
                base_url=config.openai_base_url,
            )

            content = random.choice(openai_chime_input_list).replace('$description', project['description'])
            logging.info(f'openai定时弹幕输入：{content}')
            completion = client.chat.completions.create(
                model=config.openai_model,
                messages=[
                    {
                        'role': 'user',
                        'content': content,
                    },
                ],
                extra_body={
                    'enable_enhancement': True,
                },
                timeout=8
            )
            logging.info(f'openai定时弹幕输出：{completion.choices[0].message.content}')
            content = completion.choices[0].message.content.replace('"', '').replace('“', '').replace('”', '')
            return content

        except Exception as e:
            logging.info(f'openai定时弹幕异常：{e}')
            return ''

    # 无需自动回复
    return ''


def get_interact_text(message: dict) -> dict or None:
    """获取交互文本，无需交互时返回None
    {user: str, content: str}
    """

    project = api.get_project()
    if project is None:
        return None

    try:
        client = OpenAI(
            api_key=config.openai_api_key,
            base_url=config.openai_base_url,
        )

        content = config.openai_input.replace('$description', project['description']).replace('$question', message['content'])
        logging.info(f'openai提问：{content}')
        completion = client.chat.completions.create(
            model=config.openai_model,
            messages=[
                {
                    'role': 'user',
                    'content': content,
                },
            ],
            extra_body={
                'enable_enhancement': True,
            },
            timeout=8
        )
        logging.info(f'openai回答：{completion.choices[0].message.content}')
        content = completion.choices[0].message.content.replace('"', '').replace('“', '').replace('”', '')
        if not content.endswith('。') and not content.endswith('！'):
            content += '。'
        return {'user': message['user'], 'content': content}

    except Exception as e:
        logging.info(f'openai异常：{e}')
        return None
