# -*- coding: utf-8 -*-
import time
import logging
from shuziren.data import tts_helper
from shuziren.data import manuscript_helper, live_helper, clock_helper
from common import const
from util import process_util


def run():
    """TTS线程，每次获取最新产品话术，生成10条2~6秒的音频，满30条时暂停生成
    """

    # 等待TTS服务启动
    while not process_util.is_port_listening(const.TTS1_PORT):
        time.sleep(1)

    # 开始生成
    while True:
        time.sleep(0.2)
        # 报时
        clock_text = clock_helper.get_tts_clock_text()
        if clock_text != '':
            logging.warning(f'即将报时：{clock_text}')
            __tts([clock_text], insert_to_head=True)

        # 交互，最多播报3条，丢弃其余部分
        if len(live_helper.interact_text_list) > 0:
            logging.warning(f'触发最新的3条交互：{live_helper.interact_text_list}')
            interact_text_list = live_helper.interact_text_list[:3]
            live_helper.interact_text_list = []
            __tts(interact_text_list, insert_to_head=True)

        # 话术文本，队列充足时，进入等待状态
        if len(live_helper.wav_list) < const.WAV_PREPARE_MAX_COUNT:
            manuscript_list = manuscript_helper.get_manuscript_list()
            __tts(manuscript_list)


def __tts(tts_text_list: list, insert_to_head: bool = False):
    """文本转语音，转换后追加到wav队列
    """

    # 等待GPU锁释放
    while live_helper.gpu_lock:
        time.sleep(0.02)

    t1 = time.time()
    logging.warning(f'开始TTS：{tts_text_list}')

    # GPU加锁，批量TTS生成音频，追加到wav队列尾部，完成后释放GPU锁
    live_helper.gpu_lock = True
    wav_path_list, pure_text_list, goods_index_list = tts_helper.tts(tts_text_list, is_assistant=insert_to_head)
    live_helper.gpu_lock = False

    t2 = time.time()
    logging.warning(f'TTS生成完毕，耗时：{round(t2 - t1, 2)}')

    for index, wav_path in enumerate(wav_path_list):
        wav = live_helper.wav_obj(wav_path, pure_text_list[index], goods_index_list[index])
        live_helper.insert_wav(wav, is_assistant=insert_to_head)
