# -*- coding: utf-8 -*-
import logging
import tornado.web
import tornado.ioloop
from shuziren import live_service
from shuziren.controller.live_handler import LiveHandler
from common import const, filesystem
from util import log_util, common_util, request_util


def __config_tornado():
    """配置tornado
    """

    tornado.web.Application([
        # 直播管理
        ('/live/.*', LiveHandler)

    ], static_hash_cache=False).listen(const.SHUZIREN_PORT, xheaders=True, max_buffer_size=1024 * 1024 * 1024 * 10)


if __name__ == '__main__':
    """数字人客户端
    """

    log_util.init_logging()
    logging.warning('数字人客户端已启动')

    resp = request_util.post(f'http://127.0.0.1:{const.DAEMON_PORT}/daemon/getState')
    if resp['code'] != 0 or not resp['data']['is_online']:
        raise RuntimeError('未连接到服务器')

    # 预先创建文件夹、检查文件
    common_util.mkdir(filesystem.runtime_wav_dir)
    common_util.rmtree(filesystem.runtime_wav_dir)

    # 启动直播任务监控线程
    common_util.start_thread(live_service.start_live)

    # 启动tornado
    __config_tornado()
    tornado.ioloop.IOLoop.current().start()
